var geo;
var map;
var point;
var marker;
var gmap_edycja

function initializeGmapEdit() {
	var glng = jQuery('#glng').val();
	var glat = jQuery('#glat').val();
	var gzoom = parseInt(jQuery('#gzoom').val());
	var gmap = parseInt(jQuery('#gmap').val());
	gmap_edycja = 0;
	if (jQuery('#wpkat_nowy') || jQuery('#wpkat_edycja')) {
		gmap_edycja = 1;
	}

	if (gmap == 1) {
		point = new google.maps.LatLng(glat, glng);
	}
	else {
		point = new google.maps.LatLng(52.173931692568, 18.8525390625);
		gzoom = 5;
	}
	
	var myOptions = {
				zoom: gzoom,
        center: point,
        mapTypeId: google.maps.MapTypeId.ROADMAP
      };
	
	map = new google.maps.Map(document.getElementById('googlemap_edit'),myOptions);
	marker = new google.maps.Marker({position:point,map: map});
	if (gmap_edycja == 1) {
		marker.setDraggable(true);
	}
	
	if (gmap_edycja == 1) {
		geo = new google.maps.Geocoder();
		jQuery('#adres').change(function() {
			changePosition();
		});
		jQuery('#adres_2').change(function() {
			changePosition();
		});
		jQuery('#miejscowosc').change(function() {
			changePosition();
		});
		
		google.maps.event.addListener(marker, "drag", function() {
			jQuery('#glng').val(marker.getPosition().lng());
			jQuery('#glat').val(marker.getPosition().lat());
			jQuery('#gmap').val(1);
		});

		google.maps.event.addListener(map, "zoom_changed", function() {
			jQuery('#gzoom').val(map.getZoom());
			jQuery('#gmap').val(1);
		});
	}
}

function moveMarker(adres,count) {
	geo.geocode( { 'address': adres}, function(results, status) {
      if (status == google.maps.GeocoderStatus.OK) {
        map.setCenter(results[0].geometry.location);
        marker.setPosition(results[0].geometry.location);
				jQuery('#glng').val(marker.getPosition().lng());
	 			jQuery('#glat').val(marker.getPosition().lat());
	 			map.setZoom(15);
      } 
    });	
}

function changePosition() {
	var adres = jQuery('#wojewodztwo').val()+", "+jQuery('#miejscowosc').val()+", "+jQuery('#adres').val()+", "+jQuery('#adres_2').val();
	//alert(adres);
	moveMarker(adres,1);
}


function initializeGmapView() {
	if (gmap_points.length == 0) {
		return;
	}
	var gmat_point = null;
	for (var i=0;i<gmap_points.length;i++) {		
		gmap_point = gmap_points[i];
		var glng = parseFloat(gmap_point['lng']);
		var glat = parseFloat(gmap_point['lat']);
		var gzoom = parseInt(gmap_point['zoom']);
		var point_view = new google.maps.LatLng(glat, glng);
		if (gmap_points.length == 1) {
			var gmap_div = 'googlemap';
		}
		else {
			var gmap_div = 'googlemap_'+gmap_point['id'];
		}
		if (typeof(gmap_div) != "undefined" && gmap_div != null) {
			var myOptions = {
						zoom: gzoom,
    		    center: point_view,
      		  mapTypeId: google.maps.MapTypeId.ROADMAP
      		};
			var map_view = new google.maps.Map(document.getElementById(gmap_div),myOptions);
			var marker_view = new google.maps.Marker({position:point_view,map: map_view});
		}
	}
}

function initializeGmapHome() {
	var gmap_div = 'googlemap_home';
	var point_view = new google.maps.LatLng(52.173931692568, 18.8525390625);
	var myOptions = {
				zoom: 6,
 		    center: point_view,
   		  mapTypeId: google.maps.MapTypeId.ROADMAP,
   		  featureType: "administrative"
   		};
	var map_view = new google.maps.Map(document.getElementById(gmap_div),myOptions);
	var geokoder = new google.maps.Geocoder();
	var lat_min = 1000;
	var lat_max = -1000;
	var lng_min = 1000;
	var lng_max = -1000;
	jQuery('.wpkat_lok_link').each(
		function(i){
			var adres = jQuery(this).html();
			var link = jQuery(this).attr('href');
			var position = jQuery(this).attr('position');
			if (position != '') {
				var latlng = position.split(',');
				latlng[0] = parseFloat(latlng[0]);
				latlng[1] = parseFloat(latlng[1]);
				if (latlng[0] < lat_min) {
					lat_min = latlng[0];
				}
				if (latlng[0] > lat_max) {
					lat_max = latlng[0];
				}
				if (latlng[1] < lng_min) {
					lng_min = latlng[1];
				}
				if (latlng[1] > lng_max) {
					lng_max = latlng[1];
				}
				var loc = new google.maps.LatLng(latlng[0],latlng[1]);
        var wskaznik = new google.maps.Marker({position: loc, map: map_view, title: adres, url: link});
        google.maps.event.addListener(wskaznik, 'click', function() {
      		window.location.href = this.url;  
    		});
			}
   		if (i == jQuery('.wpkat_lok_link').size()-1 && i != 1) {
   			map_view.fitBounds(new google.maps.LatLngBounds(new google.maps.LatLng(lat_min, lng_min), new google.maps.LatLng(lat_max, lng_max)));
   		}							
		}
	);
}


function initializeGmapWidget() {
	var gmap_div = 'googlemap_widget';
	var point_view = new google.maps.LatLng(52.173931692568, 18.8525390625);
	var myOptions = {
				zoom: 5,
 		    center: point_view,
   		  mapTypeId: google.maps.MapTypeId.ROADMAP,
   		  featureType: "administrative"
   		};
	var map_view = new google.maps.Map(document.getElementById(gmap_div),myOptions);
	var geokoder = new google.maps.Geocoder();
	var lat_min = 1000;
	var lat_max = -1000;
	var lng_min = 1000;
	var lng_max = -1000;
	jQuery.each(gmap_elements,
		function (i,gmap_element) {
				var latlng = new Array();
				latlng[0] = parseFloat(gmap_element[1]);
				latlng[1] = parseFloat(gmap_element[2]);
				if (latlng[0] < lat_min) {
					lat_min = latlng[0];
				}
				if (latlng[0] > lat_max) {
					lat_max = latlng[0];
				}
				if (latlng[1] < lng_min) {
					lng_min = latlng[1];
				}
				if (latlng[1] > lng_max) {
					lng_max = latlng[1];
				}
				var loc = new google.maps.LatLng(latlng[0],latlng[1]);
        var wskaznik = new google.maps.Marker({position: loc, map: map_view, title: gmap_element[3], url: gmap_element[4], icon: gmap_element[5]});
        jQuery("#gmap_marker_"+gmap_element[0]).attr("src",gmap_element[5]);
        jQuery("#gmap_marker_"+gmap_element[0]).css("display","inline");
        google.maps.event.addListener(wskaznik, 'click', function() {
      		window.location.href = this.url;  
    		});
   		if (i == gmap_elements.length-1) { 				
	   		if (lat_min == lat_max && lng_min == lng_max) {
  	 			map_view.setZoom(15);
  	 			map_view.setOptions({'center':new google.maps.LatLng(lat_min, lng_min)});
   			}
   			else {
   				map_view.fitBounds(new google.maps.LatLngBounds(new google.maps.LatLng(lat_min, lng_min), new google.maps.LatLng(lat_max, lng_max)));
   			}
   		}							
		}
	);
}


function initializeGmap() {
	if(typeof(gmap_points) != "undefined"){
		initializeGmapView();
	}
	if (document.getElementById('googlemap_edit') != null) {
		initializeGmapEdit();
	}
	if (document.getElementById('googlemap_home') != null) {
		initializeGmapHome();
	}
	if (document.getElementById('googlemap_widget') != null) {
		initializeGmapWidget();
	}
}

function loadScriptGmapView() {
  var script = document.createElement("script");
  script.type = "text/javascript";
  script.src = "//maps.googleapis.com/maps/api/js?sensor=false&callback=initializeGmap";
  document.body.appendChild(script);
}

function wlog(message){
	if(typeof console == "object"){
		console.log(message);
	}
}

jQuery(document).ready(function() {
	loadScriptGmapView();
});